
@extends('layouts.print')

@section('content')
<style>
    .table {
        width: 100%;
        max-width: 100%;
        margin-bottom: 10px !important;
    }
 
</style>
<div class="page-purchases">
    <div class="container">
        <div class="row">
            <div class="col-sm-12 col-xs-12">
                <div class="pull-left mr-bt">
                    <img src="{{asset('images/logo.png')}}" alt="" width="120">
                </div>
                <div class="pull-right">
                    <div class="title-add">
                        <h2>{{__('administrator.driver_voucher')}} </h2>
                        <table class="table table-striped">
                            <tr>
                                <td><b class="pull-left">  {{__('administrator.invoice')}}  :</b></td>
                                <td><span class="pull-left">{{ $data[0]->inovice }}</span></td>
                            </tr>
                            <tr>
                                <td><b class="pull-left">  {{__('administrator.driver_voucher')}} {{__('administrator.date')}}  :</b></td>

                                <td><span class="pull-left">{{ date("d-m-Y", strtotime($data[0]->delivery_date))}}</span></td>
                            </tr>
                            <tr>
                                <td><b class="pull-left">{{__('administrator.driver_name')}}  :</b></td>
                                <td><span class="pull-left">{{$data[0]->driver_name}}</span></td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="summary-header">

        <div class="wrapper-table">
                    <table width="100%" class="table table-striped">
                        <thead>
                        <tr>
                            <th>#</th>
                            <th>ទីតាំង</th>
                            <th>លេខអ្នទទួល</th>
                            <th>ប្រភេទ</th>
                            <th>តម្លៃ</th>
                            <th>តម្លៃសេវា</th>
                            <th>តម្លៃឡាន</th>
                            <th>តម្លៃសរុប</th>
                            <th>កំណត់សម្គាល់</th>
                            <th>ឈ្មោះហាង</th>
                            <th>លេខកូដ</th>
                        </tr>
                        </thead>
                            <tbody style="text-align: center;">

                                <?php
                                    $total = 0;
                                    $sub_total= 0;

                                ?>
                                @foreach ($data as $key=>$val)
                                <?php
                                    if($val->status == 4){
                                        $style = 'background: #f3cccf !important';
                                    }else if($val->status == 2){
                                        $style = 'background: #ddd !important';
                                    }else if($val->status == 1){
                                        $style = 'background: #fefdf0 !important';
                                    }else{
                                        $style = '';
                                    }
                                ?>
                                <tr align="center" style="{{$style}}">
                                    <td>{{$key+1}}</td>
                                    <td>{{$val->name_location}}</td>
                                    <td>{{$val->customer_receive}}</td>
                                    <td>{{$val->category_name}}</td>
                                    <td>${{number_format($val->total_price, 2)}}</td>
                                    <td>
                                    <?php
                                         if($val->delivery_status == 1){   // shop
                                            echo  (number_format($val->delivery_fee,2));
                                            $delivery_fee = 0;
                                         }
                                         else if($val->delivery_status == 2){   //cus
                                            echo  (number_format($val->delivery_fee, 2)) ;
                                            $delivery_fee = $val->delivery_fee;

                                         }
                                    ?>
                                        </td>
                                    <?php
                                         if($val->taxi_status == 1){
                                            $taxi_fee =  (number_format($val->taxi_shop_fee, 2));
                                         }
                                         elseif($val->taxi_status == 2){
                                            $taxi_fee =  (number_format($val->taxi_cust_fee, 2));
                                         }
                                         else{
                                            $taxi_fee = 0;
                                         }
                                    ?>


                                    <td>------</td>
                                    <td>
                                        <?php
                                            $sub_total  = $val->total_price  + $delivery_fee ;

                                            echo   '$'.number_format($sub_total, 2);

                                        ?>
                                    </td>
                                    <td>{{  $val->description}}</td>
                                    <td>{{ $val->shop_name}}/{{ $val->phone}}</td>
                                    <td>{{ $val->box_code}}</td>
                                    <?php
                                        $total   += $val->total_price ;
                                    ?>
                                </tr>
                            @endforeach

                            </tr>
                        </tbody>
                        <tfoot class="label-right">
                        <tr>
                            <th colspan="10" class="text-right" ><b>តម្លៃទំនិញសរុប :</b></th>
                            <th>${{number_format($total, 2)}}</th>
                        </tr>
                        <tr>
                            <th colspan="10" class="text-right"><b>តម្លៃសេវាកម្មសរុប :</b></th>
                            <th>${{number_format($total_delivery_fee, 2)}}</th>
                        </tr>
                        <tr>
                            <th colspan="10" class="text-right"><b>តម្លៃឡានសរុប :</b></th>
                            <th class="purchase_total">${{number_format($total_taxi_cust_fee, 2)}}</th>
                        </tr>

                    </tfoot>
                    </table>
                </div>


    </div>
</div>


@endsection

